---------------
-- Footspeed Gym
---------------

local MadMatt = setmetatable({},NPC):new( 9, 3, "MadMatt 4x4.png", "Down" )

MadMatt.Action = function()


	if SRT.Defeated.MadMatt then
		SRT.Dialog.Words = {{text=THEME:GetString("FootspeedGym", "8")}}
	else

		SRT.Dialog.Words = {
			{ text=THEME:GetString("FootspeedGym", "1") },
			{ text=THEME:GetString("FootspeedGym", "2") },
			{ text=THEME:GetString("FootspeedGym", "3") },
			{ text=THEME:GetString("FootspeedGym", "4") },
			{ text=THEME:GetString("FootspeedGym", "5") },
			{ text=THEME:GetString("FootspeedGym", "6") },
			{ text=THEME:GetString("FootspeedGym", "7") },
			{
				text=function()
					TransitionToBattle(2)
					return ""
				end
			}
		}
	end

	StartDialog("#bc4848", "Mad Matt")
end

return {

	--exit map via bottom
	{
		Tile = { r=9, d=11 },
		Trigger = "PlayerTouch",
		Action = function()
			SRT.Transition.NextMap="Hometown"
			SRT.Transition.NextPos={ r=37, d=4, z=-1 }
			SRT.MapFade:queuecommand("FadeOut")
		end

	},

	-- EndGame
	{
		Tile = { r=9, d=9 },
		Trigger = "PlayerTouch",
		Action = function()
			if IsEndGame() then
				SRT.Dialog.Words = {{text="HEEEEEEEELP!!!\n" .. SRT.Player.Name .. ", come to the Pokémon Center quickly!"}}
				StartDialog("#666666", "Sami")
			end
		end
	},

	MadMatt,


	-- red torches
	setmetatable({}, AnimatedSprite):new(8, 11, "redtorch", 0.1),
	setmetatable({}, AnimatedSprite):new(8, 10, "redtorch", 0.15),
	setmetatable({}, AnimatedSprite):new(8, 9, "redtorch", 0.2),
	setmetatable({}, AnimatedSprite):new(8, 8, "redtorch", 0.1),
	setmetatable({}, AnimatedSprite):new(8, 7, "redtorch", 0.125),
	setmetatable({}, AnimatedSprite):new(8, 6, "redtorch", 0.12),
	setmetatable({}, AnimatedSprite):new(7, 5, "redtorch", 0.1),
	setmetatable({}, AnimatedSprite):new(7, 4, "redtorch", 0.133),
	setmetatable({}, AnimatedSprite):new(7, 3, "redtorch", 0.2),
	setmetatable({}, AnimatedSprite):new(10, 11, "redtorch", 0.15),
	setmetatable({}, AnimatedSprite):new(10, 10, "redtorch", 0.125),
	setmetatable({}, AnimatedSprite):new(10, 9, "redtorch", 0.133),
	setmetatable({}, AnimatedSprite):new(10, 8, "redtorch", 0.135),
	setmetatable({}, AnimatedSprite):new(10, 7, "redtorch", 0.2),
	setmetatable({}, AnimatedSprite):new(10, 6, "redtorch", 0.125),
	setmetatable({}, AnimatedSprite):new(11, 5, "redtorch", 0.1),
	setmetatable({}, AnimatedSprite):new(11, 4, "redtorch", 0.135),
	setmetatable({}, AnimatedSprite):new(11, 3, "redtorch", 0.15),
}